IF EXISTS (SELECT * FROM SYS.OBJECTS WHERE NAME = 'UFD_CG_EXTRATO_FORN_SLD_ANT')
	DROP FUNCTION [dbo].[UFD_CG_EXTRATO_FORN_SLD_ANT]
GO
GO
--select * from UFD_CG_EXTRATO_FORN_SLD_ANT (1,90,'2011-01-01')
CREATE FUNCTION [dbo].[UFD_CG_EXTRATO_FORN_SLD_ANT] (@CD_EMP		INT, 
													@CD_FORN	INT,
													@DATA		DATETIME)	

RETURNS @RS_RETORNO TABLE (	DT_LANCTO	DATETIME,
							CD_FORN		INT,
							VERBA		VARCHAR(200),
							HIST		VARCHAR(200),
							NEGOCIADO   MONEY,
							CREDITO		MONEY,
							DEBITO		MONEY,
							SLD_USO		MONEY,
							SLD_RECB	MONEY)

AS
BEGIN

	INSERT INTO @RS_RETORNO

	SELECT 
		@DATA DATA,
		@CD_FORN CD_FORN,
		'SALDO ANTERIOR A ' + CONVERT(VARCHAR,@DATA, 103)  VERBA,
		'SALDO ANTERIOR A ' + CONVERT(VARCHAR,@DATA, 103)  HIST,
		ISNULL(SUM(VLR_LANC),0) AS NEGOCIADO,
		ISNULL(SUM(CREDITO),0) CREDITO,
		ISNULL(SUM(DEBITO),0) DEBITO,
		ISNULL(SUM(VLR_LANC) - SUM(DEBITO),0) AS SLD_USO,
		ISNULL(SUM(VLR_LANC) - SUM(CREDITO),0) AS SLD_RECB

	FROM
		(

			SELECT
				0 CREDITO,
				0 DEBITO,
				SUM(VLR_LANC - VLR_GLOSA) VLR_LANC
			FROM 
				CG_FND_VERBA V
			WHERE
				V.CD_EMP=@CD_EMP
				AND V.CD_FORN = @CD_FORN		
				AND V.DT_LANCTO < @DATA
				AND V.STATUS=0
			UNION ALL
			SELECT
				SUM(R.VLR_RECB) AS CREDITO,
				0 AS DEBITO, 
				0 VLR_LANC
			FROM 
				CG_FND_VERBA V
				INNER JOIN 	CG_FND_VERBA_RECB R ON
				V.CD_EMP = R.CD_EMP AND
				V.CD_FND_VERBA = R.CD_FND_VERBA
				
			WHERE
				V.CD_EMP=@CD_EMP
				AND R.STATUS=0
				AND V.CD_FORN = @CD_FORN		
				AND R.DT_RECEB < @DATA
			UNION ALL
			SELECT
				0 AS CREDITO,
				SUM(S.VLR_SAQUE) AS DEBITO,
				0 VLR_LANC
			FROM 
				CG_FND_VERBA V
				INNER JOIN CG_FND_VERBA_SAQUE S ON
				V.CD_EMP = S.CD_EMP AND
				V.CD_FND_VERBA = S.CD_FND_VERBA
			WHERE
				V.CD_EMP=@CD_EMP
				AND S.STATUS=0
				AND V.CD_FORN = @CD_FORN
				AND S.DT_SAQUE < @DATA
			UNION ALL
			SELECT
				0 AS CREDITO,
				SUM(P.VLR_VERBA_TOT) AS DEBITO,
				0 VLR_LANC
			FROM 
				CG_FND_VERBA V
				INNER JOIN CG_FND_VERBA_PROD P ON
				V.CD_EMP = P.CD_EMP AND
				V.CD_FND_VERBA = P.CD_FND_VERBA
			WHERE
				V.CD_EMP=@CD_EMP
				AND V.CD_FORN = @CD_FORN
				AND P.DT_CAD < @DATA
		) TBL 

	RETURN
END
GO


